/*
 * Copyright (c) 2020 Arturo Merino, Ondrej Micka, Torsten Muetze
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <array>
#include <cassert>
#include <unordered_map>
#include <utility>
#include <vector>
#include "small_code.hpp"

Small_code::Small_code(int n, int s) : n_(n), s_(s) {
  assert((s_ >= 1) && (s_ <= 2*n_) && "invalid value of shift s");
}

void Small_code::init(const std::vector<bool> &start){
  // if n_ is out of bounds, the object will exist in an invalid state
  if (n_ < MAX_N_PLUS_1) {
    pos_ = pos_map_[n_][s_].at(start);
  }
}

const std::array<std::vector<
    std::unordered_map<std::vector<bool>,int>>, Small_code::MAX_N_PLUS_1> Small_code::pos_map_ = {{
    {},  // n = 0 has no Gray code
    {    // n = 1
      {},
      {
        {{1,0,0}, 0},  // s = 1
        {{1,1,0}, 1},
        {{0,1,0}, 2},
        {{0,1,1}, 3},
        {{0,0,1}, 4},
        {{1,0,1}, 5}
      },
      {
        {{1,0,0}, 0},  // s = 2
        {{1,0,1}, 1},
        {{0,0,1}, 2},
        {{0,1,1}, 3},
        {{0,1,0}, 4},
        {{1,1,0}, 5}
      }
    },
    {    // n = 2
      {},
      {
        {{1,1,0,0,0}, 0},  // s = 1
        {{1,1,0,0,1}, 1},
        {{0,1,0,0,1}, 2},
        {{0,1,1,0,1}, 3},
        {{0,1,1,0,0}, 4},
        {{1,1,1,0,0}, 5},
        {{1,0,1,0,0}, 6},
        {{1,0,1,1,0}, 7},
        {{0,0,1,1,0}, 8},
        {{0,1,1,1,0}, 9},
        {{0,1,0,1,0}, 10},
        {{0,1,0,1,1}, 11},
        {{0,0,0,1,1}, 12},
        {{0,0,1,1,1}, 13},
        {{0,0,1,0,1}, 14},
        {{1,0,1,0,1}, 15},
        {{1,0,0,0,1}, 16},
        {{1,0,0,1,1}, 17},
        {{1,0,0,1,0}, 18},
        {{1,1,0,1,0}, 19}
      },
      {
        {{1,1,0,0,0}, 0},  // s = 2
        {{1,1,1,0,0}, 1},
        {{1,0,1,0,0}, 2},
        {{1,0,1,1,0}, 3},
        {{0,0,1,1,0}, 4},
        {{0,0,1,1,1}, 5},
        {{0,0,1,0,1}, 6},
        {{1,0,1,0,1}, 7},
        {{1,0,0,0,1}, 8},
        {{1,1,0,0,1}, 9},
        {{0,1,0,0,1}, 10},
        {{0,1,1,0,1}, 11},
        {{0,1,1,0,0}, 12},
        {{0,1,1,1,0}, 13},
        {{0,1,0,1,0}, 14},
        {{0,1,0,1,1}, 15},
        {{0,0,0,1,1}, 16},
        {{1,0,0,1,1}, 17},
        {{1,0,0,1,0}, 18},
        {{1,1,0,1,0}, 19}
      },
      {
        {{1,1,0,0,0}, 0},  // s = 3
        {{1,1,0,0,1}, 1},
        {{0,1,0,0,1}, 2},
        {{0,1,0,1,1}, 3},
        {{0,0,0,1,1}, 4},
        {{0,0,1,1,1}, 5},
        {{0,0,1,0,1}, 6},
        {{0,1,1,0,1}, 7},
        {{0,1,1,0,0}, 8},
        {{1,1,1,0,0}, 9},
        {{1,0,1,0,0}, 10},
        {{1,0,1,0,1}, 11},
        {{1,0,0,0,1}, 12},
        {{1,0,0,1,1}, 13},
        {{1,0,0,1,0}, 14},
        {{1,0,1,1,0}, 15},
        {{0,0,1,1,0}, 16},
        {{0,1,1,1,0}, 17},
        {{0,1,0,1,0}, 18},
        {{1,1,0,1,0}, 19}
      },
      {
        {{1,1,0,0,0}, 0},  // s = 4
        {{1,1,1,0,0}, 1},
        {{1,0,1,0,0}, 2},
        {{1,0,1,0,1}, 3},
        {{1,0,0,0,1}, 4},
        {{1,1,0,0,1}, 5},
        {{0,1,0,0,1}, 6},
        {{0,1,0,1,1}, 7},
        {{0,0,0,1,1}, 8},
        {{1,0,0,1,1}, 9},
        {{1,0,0,1,0}, 10},
        {{1,0,1,1,0}, 11},
        {{0,0,1,1,0}, 12},
        {{0,0,1,1,1}, 13},
        {{0,0,1,0,1}, 14},
        {{0,1,1,0,1}, 15},
        {{0,1,1,0,0}, 16},
        {{0,1,1,1,0}, 17},
        {{0,1,0,1,0}, 18},
        {{1,1,0,1,0}, 19}
      },
    },
    {    // n = 3
      {{}},
      {
        {{1,1,1,0,0,0,0}, 0},  // s = 1
        {{1,1,1,0,0,1,0}, 1},
        {{1,0,1,0,0,1,0}, 2},
        {{1,0,1,0,1,1,0}, 3},
        {{1,0,0,0,1,1,0}, 4},
        {{1,0,0,1,1,1,0}, 5},
        {{1,0,0,1,1,0,0}, 6},
        {{1,1,0,1,1,0,0}, 7},
        {{0,1,0,1,1,0,0}, 8},
        {{0,1,1,1,1,0,0}, 9},
        {{0,1,1,1,0,0,0}, 10},
        {{0,1,1,1,0,0,1}, 11},
        {{0,1,0,1,0,0,1}, 12},
        {{0,1,0,1,0,1,1}, 13},
        {{0,1,0,0,0,1,1}, 14},
        {{0,1,0,0,1,1,1}, 15},
        {{0,1,0,0,1,1,0}, 16},
        {{0,1,1,0,1,1,0}, 17},
        {{0,0,1,0,1,1,0}, 18},
        {{0,0,1,1,1,1,0}, 19},
        {{0,0,1,1,1,0,0}, 20},
        {{1,0,1,1,1,0,0}, 21},
        {{1,0,1,0,1,0,0}, 22},
        {{1,0,1,0,1,0,1}, 23},
        {{1,0,1,0,0,0,1}, 24},
        {{1,0,1,0,0,1,1}, 25},
        {{0,0,1,0,0,1,1}, 26},
        {{0,0,1,1,0,1,1}, 27},
        {{0,0,0,1,0,1,1}, 28},
        {{0,0,0,1,1,1,1}, 29},
        {{0,0,0,1,1,1,0}, 30},
        {{0,1,0,1,1,1,0}, 31},
        {{0,1,0,1,0,1,0}, 32},
        {{1,1,0,1,0,1,0}, 33},
        {{1,1,0,1,0,0,0}, 34},
        {{1,1,0,1,0,0,1}, 35},
        {{1,0,0,1,0,0,1}, 36},
        {{1,0,0,1,1,0,1}, 37},
        {{1,0,0,0,1,0,1}, 38},
        {{1,0,0,0,1,1,1}, 39},
        {{0,0,0,0,1,1,1}, 40},
        {{0,0,1,0,1,1,1}, 41},
        {{0,0,1,0,1,0,1}, 42},
        {{0,1,1,0,1,0,1}, 43},
        {{0,1,1,0,1,0,0}, 44},
        {{1,1,1,0,1,0,0}, 45},
        {{1,1,0,0,1,0,0}, 46},
        {{1,1,0,0,1,1,0}, 47},
        {{1,1,0,0,0,1,0}, 48},
        {{1,1,0,0,0,1,1}, 49},
        {{1,0,0,0,0,1,1}, 50},
        {{1,0,0,1,0,1,1}, 51},
        {{1,0,0,1,0,1,0}, 52},
        {{1,0,1,1,0,1,0}, 53},
        {{0,0,1,1,0,1,0}, 54},
        {{0,1,1,1,0,1,0}, 55},
        {{0,1,1,0,0,1,0}, 56},
        {{0,1,1,0,0,1,1}, 57},
        {{0,1,1,0,0,0,1}, 58},
        {{1,1,1,0,0,0,1}, 59},
        {{1,1,0,0,0,0,1}, 60},
        {{1,1,0,0,1,0,1}, 61},
        {{0,1,0,0,1,0,1}, 62},
        {{0,1,0,1,1,0,1}, 63},
        {{0,0,0,1,1,0,1}, 64},
        {{0,0,1,1,1,0,1}, 65},
        {{0,0,1,1,0,0,1}, 66},
        {{1,0,1,1,0,0,1}, 67},
        {{1,0,1,1,0,0,0}, 68},
        {{1,1,1,1,0,0,0}, 69}
      },
      {
        {{1,1,1,0,0,0,0}, 0},  // s = 2
        {{1,1,1,0,0,1,0}, 1},
        {{1,0,1,0,0,1,0}, 2},
        {{1,0,1,0,1,1,0}, 3},
        {{1,0,0,0,1,1,0}, 4},
        {{1,0,0,1,1,1,0}, 5},
        {{1,0,0,1,1,0,0}, 6},
        {{1,1,0,1,1,0,0}, 7},
        {{0,1,0,1,1,0,0}, 8},
        {{0,1,1,1,1,0,0}, 9},
        {{0,0,1,1,1,0,0}, 10},
        {{1,0,1,1,1,0,0}, 11},
        {{1,0,1,0,1,0,0}, 12},
        {{1,0,1,0,1,0,1}, 13},
        {{1,0,1,0,0,0,1}, 14},
        {{1,0,1,0,0,1,1}, 15},
        {{0,0,1,0,0,1,1}, 16},
        {{0,0,1,1,0,1,1}, 17},
        {{0,0,0,1,0,1,1}, 18},
        {{0,0,0,1,1,1,1}, 19},
        {{0,0,0,0,1,1,1}, 20},
        {{0,0,1,0,1,1,1}, 21},
        {{0,0,1,0,1,0,1}, 22},
        {{0,1,1,0,1,0,1}, 23},
        {{0,1,1,0,1,0,0}, 24},
        {{1,1,1,0,1,0,0}, 25},
        {{1,1,0,0,1,0,0}, 26},
        {{1,1,0,0,1,1,0}, 27},
        {{1,1,0,0,0,1,0}, 28},
        {{1,1,0,0,0,1,1}, 29},
        {{1,1,0,0,0,0,1}, 30},
        {{1,1,0,0,1,0,1}, 31},
        {{0,1,0,0,1,0,1}, 32},
        {{0,1,0,1,1,0,1}, 33},
        {{0,0,0,1,1,0,1}, 34},
        {{0,0,1,1,1,0,1}, 35},
        {{0,0,1,1,0,0,1}, 36},
        {{1,0,1,1,0,0,1}, 37},
        {{1,0,1,1,0,0,0}, 38},
        {{1,1,1,1,0,0,0}, 39},
        {{0,1,1,1,0,0,0}, 40},
        {{0,1,1,1,0,0,1}, 41},
        {{0,1,0,1,0,0,1}, 42},
        {{0,1,0,1,0,1,1}, 43},
        {{0,1,0,0,0,1,1}, 44},
        {{0,1,0,0,1,1,1}, 45},
        {{0,1,0,0,1,1,0}, 46},
        {{0,1,1,0,1,1,0}, 47},
        {{0,0,1,0,1,1,0}, 48},
        {{0,0,1,1,1,1,0}, 49},
        {{0,0,0,1,1,1,0}, 50},
        {{0,1,0,1,1,1,0}, 51},
        {{0,1,0,1,0,1,0}, 52},
        {{1,1,0,1,0,1,0}, 53},
        {{1,1,0,1,0,0,0}, 54},
        {{1,1,0,1,0,0,1}, 55},
        {{1,0,0,1,0,0,1}, 56},
        {{1,0,0,1,1,0,1}, 57},
        {{1,0,0,0,1,0,1}, 58},
        {{1,0,0,0,1,1,1}, 59},
        {{1,0,0,0,0,1,1}, 60},
        {{1,0,0,1,0,1,1}, 61},
        {{1,0,0,1,0,1,0}, 62},
        {{1,0,1,1,0,1,0}, 63},
        {{0,0,1,1,0,1,0}, 64},
        {{0,1,1,1,0,1,0}, 65},
        {{0,1,1,0,0,1,0}, 66},
        {{0,1,1,0,0,1,1}, 67},
        {{0,1,1,0,0,0,1}, 68},
        {{1,1,1,0,0,0,1}, 69}
      },
      {
        {{1,1,1,0,0,0,0}, 0},  // s = 3
        {{1,1,1,0,0,1,0}, 1},
        {{1,0,1,0,0,1,0}, 2},
        {{1,0,1,1,0,1,0}, 3},
        {{0,0,1,1,0,1,0}, 4},
        {{0,1,1,1,0,1,0}, 5},
        {{0,1,1,0,0,1,0}, 6},
        {{0,1,1,0,1,1,0}, 7},
        {{0,0,1,0,1,1,0}, 8},
        {{0,0,1,1,1,1,0}, 9},
        {{0,0,0,1,1,1,0}, 10},
        {{0,1,0,1,1,1,0}, 11},
        {{0,1,0,1,0,1,0}, 12},
        {{0,1,0,1,0,1,1}, 13},
        {{0,1,0,0,0,1,1}, 14},
        {{0,1,0,0,1,1,1}, 15},
        {{0,1,0,0,1,1,0}, 16},
        {{1,1,0,0,1,1,0}, 17},
        {{1,1,0,0,0,1,0}, 18},
        {{1,1,0,0,0,1,1}, 19},
        {{1,1,0,0,0,0,1}, 20},
        {{1,1,0,0,1,0,1}, 21},
        {{0,1,0,0,1,0,1}, 22},
        {{0,1,1,0,1,0,1}, 23},
        {{0,1,1,0,1,0,0}, 24},
        {{1,1,1,0,1,0,0}, 25},
        {{1,1,0,0,1,0,0}, 26},
        {{1,1,0,1,1,0,0}, 27},
        {{0,1,0,1,1,0,0}, 28},
        {{0,1,1,1,1,0,0}, 29},
        {{0,0,1,1,1,0,0}, 30},
        {{1,0,1,1,1,0,0}, 31},
        {{1,0,1,0,1,0,0}, 32},
        {{1,0,1,0,1,1,0}, 33},
        {{1,0,0,0,1,1,0}, 34},
        {{1,0,0,1,1,1,0}, 35},
        {{1,0,0,1,1,0,0}, 36},
        {{1,0,0,1,1,0,1}, 37},
        {{1,0,0,0,1,0,1}, 38},
        {{1,0,0,0,1,1,1}, 39},
        {{1,0,0,0,0,1,1}, 40},
        {{1,0,0,1,0,1,1}, 41},
        {{1,0,0,1,0,1,0}, 42},
        {{1,1,0,1,0,1,0}, 43},
        {{1,1,0,1,0,0,0}, 44},
        {{1,1,0,1,0,0,1}, 45},
        {{1,0,0,1,0,0,1}, 46},
        {{1,0,1,1,0,0,1}, 47},
        {{1,0,1,1,0,0,0}, 48},
        {{1,1,1,1,0,0,0}, 49},
        {{0,1,1,1,0,0,0}, 50},
        {{0,1,1,1,0,0,1}, 51},
        {{0,1,0,1,0,0,1}, 52},
        {{0,1,0,1,1,0,1}, 53},
        {{0,0,0,1,1,0,1}, 54},
        {{0,0,1,1,1,0,1}, 55},
        {{0,0,1,1,0,0,1}, 56},
        {{0,0,1,1,0,1,1}, 57},
        {{0,0,0,1,0,1,1}, 58},
        {{0,0,0,1,1,1,1}, 59},
        {{0,0,0,0,1,1,1}, 60},
        {{0,0,1,0,1,1,1}, 61},
        {{0,0,1,0,1,0,1}, 62},
        {{1,0,1,0,1,0,1}, 63},
        {{1,0,1,0,0,0,1}, 64},
        {{1,0,1,0,0,1,1}, 65},
        {{0,0,1,0,0,1,1}, 66},
        {{0,1,1,0,0,1,1}, 67},
        {{0,1,1,0,0,0,1}, 68},
        {{1,1,1,0,0,0,1}, 69}
      },
      {
        {{1,1,1,0,0,0,0}, 0},  // s = 4
        {{1,1,1,0,0,1,0}, 1},
        {{1,0,1,0,0,1,0}, 2},
        {{1,0,1,0,1,1,0}, 3},
        {{1,0,0,0,1,1,0}, 4},
        {{1,0,0,1,1,1,0}, 5},
        {{1,0,0,1,1,0,0}, 6},
        {{1,0,0,1,1,0,1}, 7},
        {{1,0,0,0,1,0,1}, 8},
        {{1,0,0,0,1,1,1}, 9},
        {{0,0,0,0,1,1,1}, 10},
        {{0,0,1,0,1,1,1}, 11},
        {{0,0,1,0,1,0,1}, 12},
        {{0,1,1,0,1,0,1}, 13},
        {{0,1,1,0,1,0,0}, 14},
        {{1,1,1,0,1,0,0}, 15},
        {{1,1,0,0,1,0,0}, 16},
        {{1,1,0,1,1,0,0}, 17},
        {{0,1,0,1,1,0,0}, 18},
        {{0,1,1,1,1,0,0}, 19},
        {{0,1,1,1,0,0,0}, 20},
        {{0,1,1,1,0,0,1}, 21},
        {{0,1,0,1,0,0,1}, 22},
        {{0,1,0,1,0,1,1}, 23},
        {{0,1,0,0,0,1,1}, 24},
        {{0,1,0,0,1,1,1}, 25},
        {{0,1,0,0,1,1,0}, 26},
        {{1,1,0,0,1,1,0}, 27},
        {{1,1,0,0,0,1,0}, 28},
        {{1,1,0,0,0,1,1}, 29},
        {{1,0,0,0,0,1,1}, 30},
        {{1,0,0,1,0,1,1}, 31},
        {{1,0,0,1,0,1,0}, 32},
        {{1,0,1,1,0,1,0}, 33},
        {{0,0,1,1,0,1,0}, 34},
        {{0,1,1,1,0,1,0}, 35},
        {{0,1,1,0,0,1,0}, 36},
        {{0,1,1,0,1,1,0}, 37},
        {{0,0,1,0,1,1,0}, 38},
        {{0,0,1,1,1,1,0}, 39},
        {{0,0,1,1,1,0,0}, 40},
        {{1,0,1,1,1,0,0}, 41},
        {{1,0,1,0,1,0,0}, 42},
        {{1,0,1,0,1,0,1}, 43},
        {{1,0,1,0,0,0,1}, 44},
        {{1,0,1,0,0,1,1}, 45},
        {{0,0,1,0,0,1,1}, 46},
        {{0,1,1,0,0,1,1}, 47},
        {{0,1,1,0,0,0,1}, 48},
        {{1,1,1,0,0,0,1}, 49},
        {{1,1,0,0,0,0,1}, 50},
        {{1,1,0,0,1,0,1}, 51},
        {{0,1,0,0,1,0,1}, 52},
        {{0,1,0,1,1,0,1}, 53},
        {{0,0,0,1,1,0,1}, 54},
        {{0,0,1,1,1,0,1}, 55},
        {{0,0,1,1,0,0,1}, 56},
        {{0,0,1,1,0,1,1}, 57},
        {{0,0,0,1,0,1,1}, 58},
        {{0,0,0,1,1,1,1}, 59},
        {{0,0,0,1,1,1,0}, 60},
        {{0,1,0,1,1,1,0}, 61},
        {{0,1,0,1,0,1,0}, 62},
        {{1,1,0,1,0,1,0}, 63},
        {{1,1,0,1,0,0,0}, 64},
        {{1,1,0,1,0,0,1}, 65},
        {{1,0,0,1,0,0,1}, 66},
        {{1,0,1,1,0,0,1}, 67},
        {{1,0,1,1,0,0,0}, 68},
        {{1,1,1,1,0,0,0}, 69}
      },
      {
        {{1,1,1,0,0,0,0}, 0},  // s = 5
        {{1,1,1,0,0,1,0}, 1},
        {{1,0,1,0,0,1,0}, 2},
        {{1,0,1,0,1,1,0}, 3},
        {{1,0,0,0,1,1,0}, 4},
        {{1,0,0,1,1,1,0}, 5},
        {{1,0,0,1,1,0,0}, 6},
        {{1,0,0,1,1,0,1}, 7},
        {{1,0,0,0,1,0,1}, 8},
        {{1,0,0,0,1,1,1}, 9},
        {{1,0,0,0,0,1,1}, 10},
        {{1,0,0,1,0,1,1}, 11},
        {{1,0,0,1,0,1,0}, 12},
        {{1,0,1,1,0,1,0}, 13},
        {{0,0,1,1,0,1,0}, 14},
        {{0,1,1,1,0,1,0}, 15},
        {{0,1,1,0,0,1,0}, 16},
        {{0,1,1,0,1,1,0}, 17},
        {{0,0,1,0,1,1,0}, 18},
        {{0,0,1,1,1,1,0}, 19},
        {{0,0,0,1,1,1,0}, 20},
        {{0,1,0,1,1,1,0}, 21},
        {{0,1,0,1,0,1,0}, 22},
        {{1,1,0,1,0,1,0}, 23},
        {{1,1,0,1,0,0,0}, 24},
        {{1,1,0,1,0,0,1}, 25},
        {{1,0,0,1,0,0,1}, 26},
        {{1,0,1,1,0,0,1}, 27},
        {{1,0,1,1,0,0,0}, 28},
        {{1,1,1,1,0,0,0}, 29},
        {{0,1,1,1,0,0,0}, 30},
        {{0,1,1,1,0,0,1}, 31},
        {{0,1,0,1,0,0,1}, 32},
        {{0,1,0,1,0,1,1}, 33},
        {{0,1,0,0,0,1,1}, 34},
        {{0,1,0,0,1,1,1}, 35},
        {{0,1,0,0,1,1,0}, 36},
        {{1,1,0,0,1,1,0}, 37},
        {{1,1,0,0,0,1,0}, 38},
        {{1,1,0,0,0,1,1}, 39},
        {{1,1,0,0,0,0,1}, 40},
        {{1,1,0,0,1,0,1}, 41},
        {{0,1,0,0,1,0,1}, 42},
        {{0,1,0,1,1,0,1}, 43},
        {{0,0,0,1,1,0,1}, 44},
        {{0,0,1,1,1,0,1}, 45},
        {{0,0,1,1,0,0,1}, 46},
        {{0,0,1,1,0,1,1}, 47},
        {{0,0,0,1,0,1,1}, 48},
        {{0,0,0,1,1,1,1}, 49},
        {{0,0,0,0,1,1,1}, 50},
        {{0,0,1,0,1,1,1}, 51},
        {{0,0,1,0,1,0,1}, 52},
        {{0,1,1,0,1,0,1}, 53},
        {{0,1,1,0,1,0,0}, 54},
        {{1,1,1,0,1,0,0}, 55},
        {{1,1,0,0,1,0,0}, 56},
        {{1,1,0,1,1,0,0}, 57},
        {{0,1,0,1,1,0,0}, 58},
        {{0,1,1,1,1,0,0}, 59},
        {{0,0,1,1,1,0,0}, 60},
        {{1,0,1,1,1,0,0}, 61},
        {{1,0,1,0,1,0,0}, 62},
        {{1,0,1,0,1,0,1}, 63},
        {{1,0,1,0,0,0,1}, 64},
        {{1,0,1,0,0,1,1}, 65},
        {{0,0,1,0,0,1,1}, 66},
        {{0,1,1,0,0,1,1}, 67},
        {{0,1,1,0,0,0,1}, 68},
        {{1,1,1,0,0,0,1}, 69}
      },
      {
        {{1,1,1,0,0,0,0}, 0},  // s = 6
        {{1,1,1,0,0,1,0}, 1},
        {{1,0,1,0,0,1,0}, 2},
        {{1,0,1,1,0,1,0}, 3},
        {{0,0,1,1,0,1,0}, 4},
        {{0,1,1,1,0,1,0}, 5},
        {{0,1,1,0,0,1,0}, 6},
        {{0,1,1,0,0,1,1}, 7},
        {{0,1,1,0,0,0,1}, 8},
        {{1,1,1,0,0,0,1}, 9},
        {{1,1,0,0,0,0,1}, 10},
        {{1,1,0,0,1,0,1}, 11},
        {{0,1,0,0,1,0,1}, 12},
        {{0,1,1,0,1,0,1}, 13},
        {{0,1,1,0,1,0,0}, 14},
        {{1,1,1,0,1,0,0}, 15},
        {{1,1,0,0,1,0,0}, 16},
        {{1,1,0,0,1,1,0}, 17},
        {{1,1,0,0,0,1,0}, 18},
        {{1,1,0,0,0,1,1}, 19},
        {{1,0,0,0,0,1,1}, 20},
        {{1,0,0,1,0,1,1}, 21},
        {{1,0,0,1,0,1,0}, 22},
        {{1,1,0,1,0,1,0}, 23},
        {{1,1,0,1,0,0,0}, 24},
        {{1,1,0,1,0,0,1}, 25},
        {{1,0,0,1,0,0,1}, 26},
        {{1,0,0,1,1,0,1}, 27},
        {{1,0,0,0,1,0,1}, 28},
        {{1,0,0,0,1,1,1}, 29},
        {{0,0,0,0,1,1,1}, 30},
        {{0,0,1,0,1,1,1}, 31},
        {{0,0,1,0,1,0,1}, 32},
        {{1,0,1,0,1,0,1}, 33},
        {{1,0,1,0,0,0,1}, 34},
        {{1,0,1,0,0,1,1}, 35},
        {{0,0,1,0,0,1,1}, 36},
        {{0,0,1,1,0,1,1}, 37},
        {{0,0,0,1,0,1,1}, 38},
        {{0,0,0,1,1,1,1}, 39},
        {{0,0,0,1,1,1,0}, 40},
        {{0,1,0,1,1,1,0}, 41},
        {{0,1,0,1,0,1,0}, 42},
        {{0,1,0,1,0,1,1}, 43},
        {{0,1,0,0,0,1,1}, 44},
        {{0,1,0,0,1,1,1}, 45},
        {{0,1,0,0,1,1,0}, 46},
        {{0,1,1,0,1,1,0}, 47},
        {{0,0,1,0,1,1,0}, 48},
        {{0,0,1,1,1,1,0}, 49},
        {{0,0,1,1,1,0,0}, 50},
        {{1,0,1,1,1,0,0}, 51},
        {{1,0,1,0,1,0,0}, 52},
        {{1,0,1,0,1,1,0}, 53},
        {{1,0,0,0,1,1,0}, 54},
        {{1,0,0,1,1,1,0}, 55},
        {{1,0,0,1,1,0,0}, 56},
        {{1,1,0,1,1,0,0}, 57},
        {{0,1,0,1,1,0,0}, 58},
        {{0,1,1,1,1,0,0}, 59},
        {{0,1,1,1,0,0,0}, 60},
        {{0,1,1,1,0,0,1}, 61},
        {{0,1,0,1,0,0,1}, 62},
        {{0,1,0,1,1,0,1}, 63},
        {{0,0,0,1,1,0,1}, 64},
        {{0,0,1,1,1,0,1}, 65},
        {{0,0,1,1,0,0,1}, 66},
        {{1,0,1,1,0,0,1}, 67},
        {{1,0,1,1,0,0,0}, 68},
        {{1,1,1,1,0,0,0}, 69}
      },
    },
}};

const std::array<std::vector<std::vector<int>>, Small_code::MAX_N_PLUS_1> Small_code::flip_sequence_ = {{
  {},  // n = 0 has no flip sequence
  {    // n = 1
    {},
    {1,0, 2,1, 0,2},  // s = 1
    {2,0, 1,2, 0,1}   // s = 2
  },
  {    // n = 2
    {},
    {4,0,2,4, 0,1,3,0, 1,2,4,1, 2,3,0,2, 3,4,1,3},  // s = 1
    {2,1,3,0, 4,3,0,2, 1,0,2,4, 3,2,4,1, 0,4,1,3},  // s = 2
    {4,0,3,1, 2,3,1,4, 0,1,4,2, 3,4,2,0, 1,2,0,3},  // s = 3
    {2,1,4,2, 1,0,3,1, 0,4,2,0, 4,3,1,4, 3,2,0,3},  // s = 4
  },
  {    // n = 3
    {},
    {5,1,4,2,3,5,1,0,2,4, 6,2,5,3,4,6,2,1,3,5, 0,3,6,4,5,0,3,2,4,6, 1,4,0,5,6,1,4,3,5,0, 2,5,1,6,0,2,5,4,6,1, 3,6,2,0,1,3,6,5,0,2, 4,0,3,1,2,4,0,6,1,3},  // s = 1
    {5,1,4,2,3,5,1,0,2,1, 0,3,6,4,5,0,3,2,4,3, 2,5,1,6,0,2,5,4,6,5, 4,0,3,1,2,4,0,6,1,0, 6,2,5,3,4,6,2,1,3,2, 1,4,0,5,6,1,4,3,5,4, 3,6,2,0,1,3,6,5,0,6},  // s = 2
    {5,1,3,0,1,3,4,1,3,2, 1,4,6,3,4,6,0,4,6,5, 4,0,2,6,0,2,3,0,2,1, 0,3,5,2,3,5,6,3,5,4, 3,6,1,5,6,1,2,6,1,0, 6,2,4,1,2,4,5,2,4,3, 2,5,0,4,5,0,1,5,0,6},  // s = 3
    {5,1,4,2,3,5,6,3,5,0, 2,5,1,6,0,2,3,0,2,4, 6,2,5,3,4,6,0,4,6,1, 3,6,2,0,1,3,4,1,3,5, 0,3,6,4,5,0,1,5,0,2, 4,0,3,1,2,4,5,2,4,6, 1,4,0,5,6,1,2,6,1,3},  // s = 4
    {5,1,4,2,3,5,6,3,5,4, 3,6,2,0,1,3,4,1,3,2, 1,4,0,5,6,1,2,6,1,0, 6,2,5,3,4,6,0,4,6,5, 4,0,3,1,2,4,5,2,4,3, 2,5,1,6,0,2,3,0,2,1, 0,3,6,4,5,0,1,5,0,6},  // s = 5
    {5,1,3,0,1,3,6,5,0,2, 4,0,2,6,0,2,5,4,6,1, 3,6,1,5,6,1,4,3,5,0, 2,5,0,4,5,0,3,2,4,6, 1,4,6,3,4,6,2,1,3,5, 0,3,5,2,3,5,1,0,2,4, 6,2,4,1,2,4,0,6,1,3},  // s = 6
  }
}};
