/*
 * Copyright (c) 2025 Torsten Muetze
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <vector>

// Loopless algorithm to generate all signed permutations of {1,...,n}
class Signed_Permutation {
public:
  Signed_Permutation(int n);
  bool next();
  void print();
  int operator [](int i) const { return signs_[i]*perm_[i]; }

private:
  int n_;

  // We maintain the permutation and the signs as two separate arrays.
  // The inverse permutation allows us to quickly retrieve the position of an element.
  std::vector<int> perm_;
  std::vector<int> signs_;
  std::vector<int> perm_inv_;

  // Data structures for bookkeeping during the zigzagging algorithm.
  // The movement (left/right) is done w.r.t. the full notation of the permutation,
  // but our arrays only contain the right half.
  enum class Direction {left, right};
  std::vector<Direction> o_;  // direction array
  std::vector<int> s_;  // select entry that performs the next transposition
};
